<?xml version="1.0" encoding="UTF-8"?>

<!--
 Copyright (C) 2006 Henning Westerholt

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc.,
 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-->

<!-- Stylesheet to create a traffic generation for a INET/ OMNeT++ network.
     Use this with e.g. xsltproc (from the libxslt package).
     Usage: xsltproc -o $OUTPUT traffic.xsl $INPUT
     The input file must be valid XML network in the "PG"-format.
-->

<!-- setup xml -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8"/>

<!-- strip whitespaces -->
<xsl:strip-space elements="*"/>

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<!-- match the PG XML Header -->
<xsl:template match="NetStDTD">
    <xsl:apply-templates/>
</xsl:template>

<!-- do nothing -->
<xsl:template match="Switches"/>
<xsl:template match="Hardware"/>
<xsl:template match="Links"/>

<!-- match Messages, append a comment -->
<xsl:template match="Messages">
# traffic definition for a INET/ OMNeT++ network
    <xsl:apply-templates/>
</xsl:template>

<!-- create the traffic definition -->
<xsl:template match="Message">
**.device_<xsl:value-of select="@SenderId"/>.cli.destStation = "device_<xsl:value-of select="@ReceiverId"/>"
</xsl:template>

</xsl:stylesheet>
