/*
 * Copyright (C) 2006 Henning Westerholt
 * Copyright (C) 2003 CTIE, Monash University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _ETHERMACTDMA_H
#define _ETHERMACTDMA_H

#include <omnetpp.h>
#include "EtherMAC.h"

/**
 * Ethernet MAC module with TDMA scheduling
 */
class INET_API EtherMACTDMA : public EtherMAC
{
  public:
    EtherMACTDMA();

  protected:
    void initialize();
    void handleMessage(cMessage *msg);

    void scheduleEndIFGPeriod();

  private:
    int checkSlotBoundary(const simtime_t slotBoundary) const;
    // Parameters controlling how the MAC operates in TDMA mode
    unsigned int timeSlotCount; // how many time slots has a TDMA cycle
    simtime_t timeSlotLength;   // time slot length of the TDMA cycle
    unsigned int actualSlot;    // the actual time slot
    unsigned long slotCounter; // slot counter for helper methods
    unsigned int slotId;
    cMessage * slotTimeEvent;
    bool isSlotted;
    simtime_t safetySlot;
    simtime_t safetyInterval;
    simtime_t testEqual;
    simtime_t interFrameGap;
};

#endif
