//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include <omnetpp.h>
#include "Ieee802Ctrl_m.h"
#include "MACAddress.h"
#include "TDMA.h"

Define_Module(TDMA);

void TDMA::initialize()
{
    QueueBase::initialize();

    numLocalDelivered = numDropped = numForwarded = 0;
    
    WATCH(numLocalDelivered);
    WATCH(numDropped);
    WATCH(numForwarded);
}

void TDMA::endService(cMessage *message)
{
    if(message->arrivalGate()->isName("transportIn"))
    {
        handleMessageFromHL(message);
    }
    else
    {
        TDMADatagram *datagram = check_and_cast<TDMADatagram *>(message);
        handlePacketFromNetwork(datagram);
    }
}

void TDMA::handlePacketFromNetwork(TDMADatagram *datagram)
{
    
    EV << "handlePacketFromNetwork\n";
}

void TDMA::handleMessageFromHL(cMessage *message)
{
    EV << "handleMessageFromHL\n";

    //TODO error handling if no output interface available
    //TDMADatagram *datagram = encapsulate(message);
    EthernetIIFrame *datagram = encapsulate(message);

    // add control info with MAC address
    MACAddress * macAddress = new MACAddress();
    Ieee802Ctrl *controlInfo = new Ieee802Ctrl();
    controlInfo->setDest(*macAddress);
    datagram->setControlInfo(controlInfo);
    // send out
    send(datagram, "queueOut");
}

// TDMADatagram* TDMA::encapsulate(cMessage *message)
// {
//     TDMADatagram *datagram = new TDMADatagram(message->name());
//     datagram->setByteLength(TDMA_HEADER_BYTES);
//     datagram->encapsulate(message);
//     return datagram;
// }
EthernetIIFrame* TDMA::encapsulate(cMessage *message)
{
    TDMADatagram *datagram = new TDMADatagram(message->name());
    datagram->setByteLength(TDMA_HEADER_BYTES);
    datagram->encapsulate(message);
    
    EthernetIIFrame *frame = new EthernetIIFrame(datagram->name());
    frame->setByteLength(ETHER_MAC_FRAME_BYTES);
    frame->setKind(ETH_FRAME);
    frame->encapsulate(datagram);
    return frame;
}

cMessage* TDMA::decapsulate(TDMADatagram* datagram)
{
//TODO
}
