//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _UTILITY_H_
#define _UTILITY_H_

class QString;

class Utility
{
    public:
        static Utility * getInstance(unsigned int randomSeed);
        ~Utility();
        static bool isPercent(const double val);

        QString generateAutoMACAddress();
        unsigned long getUniqueNumber();
        unsigned long getRandomNumber() const;
        double getDoubleRandomNumber() const;
        void resetUniqueNumber();

    private:
        Utility(const unsigned int randomSeed); // Singleton pattern
        unsigned long counter;
        unsigned long macCounter;
        unsigned long randomSeed;
        static Utility * instance;
};

#endif
