//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _FILEHANDLING_H
#define _FILEHANDLING_H

class QString;
class QFile;

class FileHandling
{
public:
    FileHandling(const QString& fileName);
    ~FileHandling();
    bool open();
    void close();
    QString * read();
    void write(const QString& content);

private:
    // disable compiler generated constructor, copy constructor and operator=
    FileHandling();
    FileHandling(const FileHandling&);
    void operator=(const FileHandling& other);

    QFile * file;
};

#endif
