//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#include <QFile>
#include <QTextStream>
#include <filehandling.h>

FileHandling::FileHandling(const QString& name) : file(new QFile(name))
{}

FileHandling::~FileHandling()
{
    delete file;
}

// open a file in read write mode
bool FileHandling::open()
{
    return (file->open(QIODevice::ReadWrite | QIODevice::Text));
}

// the destructor of QFile close the file automatically,
// so normally this methods is not needed
void FileHandling::close()
{
    file->close();
}

// @todo use a std::auto_pointer here
QString * FileHandling::read()
{
    QTextStream in(file);
    return in.string();
}

void FileHandling::write(const QString& content)
{
    // delete the old file: remove closes the file, so we use another method
    file->resize(0);
    file->flush();

    QTextStream out(file);
    out << content;
}
