//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#include <QString>
#include <QtXml>

#include <stdlib.h>
#include <memory>
#include <application.h>
#include <network.h>
#include <xmlgenerator.h>
#include <filehandling.h>

using namespace std;

void Application::createNetwork(const NetworkParameter parameter, const QString& fileName)
{
    if (!parameter.valid) {
        qDebug("Invalid parameter for the network.");
        exit(1);
    }
    auto_ptr<Network> network (new Network(parameter));
    network->createNetwork();
    //network->printTree();

    XMLGenerator xmlgen;

    xmlgen.addNetwork(*network);
    xmlgen.addLinks(*network->getLinks());
    xmlgen.addMessages(*network->getMessages());

    FileHandling fh(fileName);
    if (!fh.open()) {
        qDebug("Error on file open, please check permissions.");
        exit(1);
    }
    fh.write(xmlgen.getXML()->toString());
}
