//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __TDMA_H__
#define __TDMA_H__

#include "QueueBase.h"
#include "EtherFrame_m.h"
#include "TDMADatagram.h"


class INET_API TDMA : public QueueBase
{
public:
    // encapsulate a packet from higher layer in a TDMADatagram
    //TDMADatagram *encapsulate(cMessage *packet);
    EthernetIIFrame *encapsulate(cMessage *packet);
    // handle packet from higher layer, call encapsulate
    void handleMessageFromHL(cMessage *message);
    // handle packet arriving from lower layer
    void handlePacketFromNetwork(TDMADatagram * datagram);        
    // decapsulate and return the packet
    cMessage *decapsulate(TDMADatagram *datagram);

    TDMA() {}

protected:
    virtual void initialize();
    // processing of TDMA datagramms at the front of the queue
    virtual void endService(cMessage *msg);
    
private:
    // some statistics
    int numLocalDelivered;
    int numDropped;
    int numForwarded;
};

#endif
